/*
 * comanda ledul intern legat la pin 2
 * se conecteaza la server local prin 
 * IP192.168.0.80
 * genereaza pagina web proprie
 * lik folosit
 * https://lastminuteengineers.com/esp32-dht11-dht22-web-server-tutorial/
 */

#include <WiFi.h>
#include <WebServer.h>

const char* ssid     = "UPCF4821BC";
const char* password = "Gherla1956";
//se activeaza pentru Server Local

WebServer server(80);


uint8_t LED2pin = 2;
bool LED2status = LOW;

void setup() {
  Serial.begin(115200);  

  pinMode(LED2pin, OUTPUT);
  
  Serial.println("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
  delay(1000);
  Serial.print(".");
        }
  Serial.println("");
  Serial.println("WiFi connected..!");
  Serial.print("Got IP: ");  Serial.println(WiFi.localIP());
  
  
  server.on("/", handle_OnConnect);
  server.on("/led2on", handle_led2on);
  server.on("/led2off", handle_led2off);
  server.onNotFound(handle_NotFound);
  
  server.begin();
  Serial.println("HTTP server started");
          }
  void loop() {
  server.handleClient();
  
  if(LED2status)
  {digitalWrite(LED2pin, HIGH);}
  else
  {digitalWrite(LED2pin, LOW);}
    }

  void handle_OnConnect() {
  LED2status = LOW;
  Serial.println("GPIO2 Status: OFF | GPIO2 Status: OFF");
  server.send(200, "text/html", SendHTML(LED2status,true)); 
    }

  void handle_led2on() {
  LED2status = HIGH;
  Serial.println("GPIO2 Status: ON");
  server.send(200, "text/html", SendHTML(LED2status,true)); 
        }

  void handle_led2off() {
  LED2status = LOW;
  Serial.println("GPIO2 Status: OFF");
  server.send(200, "text/html", SendHTML(LED2status,false)); 
      }

  void handle_NotFound(){
  server.send(404, "text/plain", "Not found");
      }

String SendHTML(uint8_t led1stat,uint8_t led2stat){
  String ptr = "<!DOCTYPE html> <html>\n";
  ptr +="<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, user-scalable=no\">\n";
  ptr +="<title>LED Control</title>\n";
  ptr +="<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}\n";
  ptr +="body{margin-top: 50px;} h1 {color: #444444;margin: 50px auto 30px;} h3 {color: #444444;margin-bottom: 50px;}\n";
  ptr +=".button {display: block;width: 80px;background-color: #3498db;border: none;color: white;padding: 13px 30px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button-on {background-color: #3498db;}\n";    
  ptr +=".button-on:active {background-color: #2980b9;}\n";
  ptr +=".button-off {background-color: #34495e;}\n";
  ptr +=".button-off:active {background-color: #2c3e50;}\n";
  ptr +="p {font-size: 14px;color: #888;margin-bottom: 10px;}\n";
  ptr +="</style>\n";
  ptr +="</head>\n";
  ptr +="<body>\n";
  ptr +="<h1>ESP32 Led Web Server</h1>\n";  //optional
  ptr +="<h3>Using Local Web Mode</h3>\n";  //optional

 
    
  if(led2stat)
  {ptr +="<p>LED2 Status: ON</p><a class=\"button button-off\" href=\"/led2off\">OFF</a>\n";}
  else
  {ptr +="<p>LED2 Status: OFF</p><a class=\"button button-on\" href=\"/led2on\">ON</a>\n";}

  ptr +="</body>\n";
  ptr +="</html>\n";
  return ptr;
}
